using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;

namespace Windows_Explorer_Layout {
	public class WindowsExplorerItemLayoutForm : System.Windows.Forms.Form {
		private const int NUM_ITEMS = 50;
		private Windows_Explorer_Layout.ColumnLayoutControl columnLayoutControl;
		private System.ComponentModel.Container components = null;

		public WindowsExplorerItemLayoutForm() {
			InitializeComponent();

			PopulatePanel();
		}

		protected override void Dispose( bool disposing ) {
			if( disposing ) {
				if (components != null) {
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent() {
			this.columnLayoutControl = new Windows_Explorer_Layout.ColumnLayoutControl();
			this.SuspendLayout();
			// 
			// columnLayoutControl
			// 
			this.columnLayoutControl.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.columnLayoutControl.AutoScroll = true;
			this.columnLayoutControl.Location = new System.Drawing.Point(0, 0);
			this.columnLayoutControl.Name = "columnLayoutControl";
			this.columnLayoutControl.Size = new System.Drawing.Size(296, 272);
			this.columnLayoutControl.TabIndex = 0;
			// 
			// WindowsExplorerItemLayoutForm
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(296, 270);
			this.Controls.Add(this.columnLayoutControl);
			this.Name = "WindowsExplorerItemLayoutForm";
			this.Text = "Windows Explorer Item Layout";
			this.ResumeLayout(false);

		}
		#endregion

		[STAThread]
		static void Main() {
			Application.Run(new WindowsExplorerItemLayoutForm());
		}

		private void PopulatePanel() {
			SuspendLayout();

			string[] labels = {"Test", "Test Label", "Short", "A much longer label"};
			Random rnd = new Random();

			for (int i=0; i<NUM_ITEMS; i++) {
				string text =  labels[(int)(rnd.NextDouble() * labels.Length)] + " " + (i+1);
				Label item = new Label();
				item.Text = text;
				item.Size = new Size(item.PreferredWidth, item.PreferredHeight);
				columnLayoutControl.Add(item);
			}

			ResumeLayout();
		}
	}
}